/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity.barrel;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import novamachina.exnihilosequentia.common.blockentity.IFluidContainer;
import novamachina.exnihilosequentia.common.blockentity.barrel.BarrelFluidHandler;
import novamachina.exnihilosequentia.common.blockentity.barrel.BarrelInventoryHandler;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.AbstractBarrelMode;
import novamachina.exnihilosequentia.common.blockentity.barrel.mode.BarrelModeRegistry;
import novamachina.exnihilosequentia.common.utility.Config;

public abstract class AbstractBarrelEntity
extends BlockEntity
implements IFluidContainer {
    public static final int MAX_FLUID_AMOUNT = Config.getBarrelNumberOfBuckets() * 1000;
    public static final int MAX_SOLID_AMOUNT = Config.getBarrelMaxSolidAmount();
    @Nonnull
    private static final String INVENTORY_TAG = "inventory";
    @Nonnull
    private static final String MODE_INFO_TAG = "modeInfo";
    @Nonnull
    private static final String MODE_TAG = "barrelMode";
    @Nonnull
    private static final String SOLID_AMOUNT_TAG = "solidAmount";
    @Nonnull
    private static final String TANK_TAG = "tank";
    @Nonnull
    private final BarrelInventoryHandler inventory = new BarrelInventoryHandler(this);
    @Nonnull
    private final LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);
    @Nonnull
    private final BarrelFluidHandler tank = new BarrelFluidHandler(this);
    @Nonnull
    private final LazyOptional<IFluidHandler> tankHolder = LazyOptional.of(() -> this.tank);
    @Nullable
    private AbstractBarrelTileState lastSyncedState = null;
    @Nullable
    private AbstractBarrelMode mode = BarrelModeRegistry.getModeFromName("empty");
    private int solidAmount = 0;

    protected AbstractBarrelEntity(@Nonnull BlockEntityType<? extends AbstractBarrelEntity> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    public boolean addSolid(int amount, boolean simulate) {
        if (amount <= 0) {
            return false;
        }
        if (this.solidAmount == MAX_SOLID_AMOUNT) {
            return false;
        }
        if (!simulate) {
            this.solidAmount += amount;
            if (this.solidAmount > MAX_SOLID_AMOUNT) {
                this.solidAmount = MAX_SOLID_AMOUNT;
            }
        }
        return true;
    }

    public abstract boolean canAcceptFluidTemperature(@Nonnull FluidStack var1);

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHolder.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankHolder.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public Fluid getFluid() {
        if (!this.tank.isEmpty()) {
            return this.tank.getFluid().getFluid();
        }
        return null;
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public float getFluidProportion() {
        return (float)this.tank.getFluidAmount() / (float)MAX_FLUID_AMOUNT;
    }

    @Nonnull
    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public AbstractBarrelMode getMode() {
        return this.mode;
    }

    public void setMode(@Nonnull String nextState) {
        this.mode = BarrelModeRegistry.getModeFromName(nextState);
        if (this.mode == null) {
            this.mode = BarrelModeRegistry.getModeFromName("empty");
        }
    }

    public void setMode(@Nonnull AbstractBarrelMode mode) {
        this.mode = mode;
    }

    public int getSolidAmount() {
        return this.solidAmount;
    }

    public float getSolidProportion() {
        return (float)this.solidAmount / (float)MAX_SOLID_AMOUNT;
    }

    @Nullable
    public ResourceLocation getSolidTexture() {
        if (!this.inventory.getStackInSlot(0).m_41619_()) {
            return this.inventory.getStackInSlot(0).m_41720_().getRegistryName();
        }
        return null;
    }

    @Nonnull
    public FluidTank getTank() {
        return this.tank;
    }

    @Nonnull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public List<Component> getWailaInfo() {
        if (this.mode == null) {
            return null;
        }
        return this.mode.getWailaInfo(this);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        if (compound.m_128441_(INVENTORY_TAG)) {
            this.inventory.deserializeNBT(compound.m_128469_(INVENTORY_TAG));
        }
        if (compound.m_128441_(TANK_TAG)) {
            this.tank.readFromNBT(compound.m_128469_(TANK_TAG));
        }
        if (compound.m_128441_(MODE_TAG)) {
            this.mode = BarrelModeRegistry.getModeFromName(compound.m_128461_(MODE_TAG));
        }
        if (compound.m_128441_(MODE_INFO_TAG) && this.mode != null) {
            this.mode.read(compound.m_128469_(MODE_INFO_TAG));
        }
        if (compound.m_128441_(SOLID_AMOUNT_TAG)) {
            this.solidAmount = compound.m_128451_(SOLID_AMOUNT_TAG);
        }
        super.m_142466_(compound);
    }

    @Nullable
    public InteractionResult onBlockActivated(@Nonnull Player player, @Nonnull InteractionHand handIn, @Nonnull IFluidHandler fluidHandler, @Nonnull IItemHandler itemHandler) {
        if (this.mode == null) {
            return null;
        }
        return this.mode.onBlockActivated(this, player, handIn, fluidHandler, itemHandler);
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (nbt.m_128441_(INVENTORY_TAG)) {
            this.inventory.deserializeNBT(nbt.m_128469_(INVENTORY_TAG));
        }
        if (nbt.m_128441_(TANK_TAG)) {
            this.tank.readFromNBT(nbt.m_128469_(TANK_TAG));
        }
        this.mode = BarrelModeRegistry.getModeFromName(nbt.m_128461_(MODE_TAG));
        if (nbt.m_128441_(MODE_INFO_TAG) && this.mode != null) {
            this.mode.read(nbt.m_128469_(MODE_INFO_TAG));
        }
        this.solidAmount = nbt.m_128451_(SOLID_AMOUNT_TAG);
    }

    public void removeSolid(int amount) {
        this.solidAmount -= amount;
        if (this.solidAmount < 0) {
            this.solidAmount = 0;
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128365_(INVENTORY_TAG, (Tag)this.inventory.serializeNBT());
        compound.m_128365_(TANK_TAG, (Tag)this.tank.writeToNBT(new CompoundTag()));
        if (this.mode != null) {
            compound.m_128359_(MODE_TAG, this.mode.getModeName());
            compound.m_128365_(MODE_INFO_TAG, (Tag)this.mode.write());
        }
        compound.m_128405_(SOLID_AMOUNT_TAG, this.solidAmount);
    }

    public void m_7651_() {
        super.m_7651_();
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)this.inventory.getStackInSlot(0));
        if (this.f_58857_ != null) {
            Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.f_58858_, (NonNullList)list);
        }
    }

    public void tickServer() {
        BlockPos abovePos;
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || this.mode == null) {
            return;
        }
        if ((this.mode.isEmptyMode() || this.mode.getModeName().equals("fluid")) && this.f_58857_.m_46758_(abovePos = this.f_58858_.m_142082_(0, 1, 0)) && this.tank.getSpace() >= Config.getRainFillAmount()) {
            FluidStack stack = new FluidStack((Fluid)Fluids.f_76193_, Config.getRainFillAmount());
            this.tank.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
        this.mode.tick(this);
        AbstractBarrelTileState currentState = new AbstractBarrelTileState(this);
        if (!currentState.equals(this.lastSyncedState)) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            this.lastSyncedState = currentState;
        }
    }

    protected static class AbstractBarrelTileState {
        @Nullable
        private final Fluid fluid;
        private final int fluidAmount;
        @Nonnull
        private final Item solid;
        private final int solidAmount;
        @Nonnull
        private final List<Component> wailaInfo;

        AbstractBarrelTileState(@Nonnull AbstractBarrelEntity abstractBarrelEntity) {
            this.fluid = abstractBarrelEntity.getFluid();
            this.fluidAmount = abstractBarrelEntity.getFluidAmount();
            this.solid = abstractBarrelEntity.inventory.getStackInSlot(0).m_41720_();
            this.solidAmount = abstractBarrelEntity.getSolidAmount();
            this.wailaInfo = abstractBarrelEntity.getWailaInfo();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractBarrelTileState that = (AbstractBarrelTileState)o;
            return this.fluidAmount == that.fluidAmount && this.solidAmount == that.solidAmount && Objects.equals(this.fluid, that.fluid) && Objects.equals(this.solid, that.solid) && Objects.equals(this.wailaInfo, that.wailaInfo);
        }

        public int hashCode() {
            return Objects.hash(this.fluid, this.fluidAmount, this.solid, this.solidAmount, this.wailaInfo);
        }
    }
}

